import { ComponentEmit } from 'vue-component-type-helpers';
import { ElTable, ElTableColumn } from 'element-plus';

export type unionToRecord<T extends string> = Record<T, string>;

export type TableEmits = ComponentEmit<typeof ElTable>;

export type TableType = InstanceType<typeof ElTable> | null;

export type TableSlots<T, S extends string | undefined = undefined> = {
  headerSlot: (props: {
    index: number;
    row: T;
    slotName: S extends undefined
      ? keyof T
      : keyof (T & unionToRecord<Extract<S, string>>);
  }) => any;
  contentSlot: (props: {
    index: number;
    row: T;
    slotName: S extends undefined
      ? keyof T | 'operation'
      : keyof (T & unionToRecord<Extract<S, string>>) | 'operation';
  }) => any;
};

export type TableProps<T, S extends string | undefined = undefined> = {
  dataList: T[];
  tableList?: TableColumn<T, S>;
  loading?: boolean;
};

export type TableList<T, S extends string | undefined = undefined> = {
  header: S extends undefined
    ? keyof T
    : keyof (T & unionToRecord<Extract<S, string>>);
  slotName: S extends undefined
    ? keyof T | 'operation'
    : keyof (T & unionToRecord<Extract<S, string>>) | 'operation';
  prop: S extends undefined
    ? keyof T | 'operation'
    : keyof (T & unionToRecord<Extract<S, string>>) | 'operation';
  formatter: (
    row: T,
    column: TableColumn<T, S>,
    cellValue: any,
    index: number
  ) => any;
  type: 'selection' | 'index' | 'expand';
  fixed: 'left' | 'right';
  align: 'left' | 'center' | 'right';
  headerAlign: 'left' | 'center' | 'right';
  filterPlacement:
    | 'top'
    | 'top-start'
    | 'top-end'
    | 'bottom'
    | 'bottom-start'
    | 'bottom-end'
    | 'left'
    | 'left-start'
    | 'left-end'
    | 'right'
    | 'right-start'
    | 'right-end';
};

type CoverAttribute =
  | 'formatter'
  | 'type'
  | 'align'
  | 'headerAlign'
  | 'filterPlacement';

export type TableColumn<T, S extends string | undefined = undefined> = Partial<
  Omit<InstanceType<typeof ElTableColumn>, CoverAttribute> & TableList<T, S>
>[];

export type BucketData = {
  id: string;
  name: string;
  is_enabled: boolean;
  max_objects: number;
  max_size: number;
  owner: string;
  placement: string;
  used: string;
  objects: number;
  used_percent: number;
  used_bytes: number;
};
